/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.event;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.utils.FastEither;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.items.VoltmeterItem;
import blusunrize.immersiveengineering.common.network.MessageRequestEnergyUpdate;
import blusunrize.immersiveengineering.common.network.MessageRequestRedstoneUpdate;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.Utils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public class GameOverlayEventHandler {
    @SubscribeEvent
    public void onRenderOverlayPost(RenderGuiOverlayEvent.Post event) {
        if (ModList.get().isLoaded("immersiveengineering")) {
            int scaledWidth = Minecraft.m_91087_().m_91268_().m_85445_();
            int scaledHeight = Minecraft.m_91087_().m_91268_().m_85446_();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            boolean hasVoltmeter = false;
            if (player != null && event.getOverlay().id().equals((Object)VanillaGuiOverlay.ITEM_NAME.id())) {
                CompoundTag tags;
                ItemStack stack = player.m_6844_(EquipmentSlot.HEAD);
                for (InteractionHand hand : InteractionHand.values()) {
                    ItemStack equipped;
                    if (player.m_21120_(hand).m_41619_() || (equipped = player.m_21120_(hand)).m_41720_() != IEItems.Tools.VOLTMETER.get()) continue;
                    hasVoltmeter = true;
                }
                if (!stack.m_41619_() && !hasVoltmeter && (tags = stack.m_41783_()) != null && tags.m_128441_("ie_voltmeter")) {
                    PoseStack transform = new PoseStack();
                    MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                    this.renderVoltmeterOverlay((Player)player, scaledWidth, scaledHeight, transform, (MultiBufferSource)buffer);
                    buffer.m_109911_();
                }
            }
        }
    }

    private void renderVoltmeterOverlay(Player player, float scaledWidth, float scaledHeight, PoseStack transform, MultiBufferSource buffer) {
        HitResult rrt = ClientUtils.mc().f_91077_;
        FastEither pos = null;
        if (rrt instanceof BlockHitResult) {
            BlockHitResult mop = (BlockHitResult)rrt;
            pos = FastEither.left((Object)mop.m_82425_());
        } else if (rrt instanceof EntityHitResult) {
            EntityHitResult ehr = (EntityHitResult)rrt;
            pos = FastEither.right((Object)ehr.m_82443_().m_19879_());
        }
        if (pos == null) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        boolean matches = VoltmeterItem.lastEnergyUpdate.pos().equals((Object)pos);
        long sinceLast = player.f_19853_.m_46467_() - VoltmeterItem.lastEnergyUpdate.measuredInTick();
        if (!matches || sinceLast > 20L) {
            ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageRequestEnergyUpdate(pos));
        }
        if (VoltmeterItem.lastEnergyUpdate.isValid() && matches) {
            int maxStorage = VoltmeterItem.lastEnergyUpdate.capacity();
            int storage = VoltmeterItem.lastEnergyUpdate.stored();
            String storageText = Utils.toScientificNotation((int)storage, (String)"0##", (int)100000);
            String capacityText = Utils.toScientificNotation((int)maxStorage, (String)"0##", (int)100000);
            text.addAll(Arrays.asList(I18n.m_118938_((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{"<br>" + storageText + " / " + capacityText}).split("<br>")));
        }
        if (pos.isLeft()) {
            matches = VoltmeterItem.lastRedstoneUpdate.pos().equals(pos.leftNonnull());
            sinceLast = player.f_19853_.m_46467_() - VoltmeterItem.lastRedstoneUpdate.measuredInTick();
            if (!matches || sinceLast > 20L) {
                ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageRequestRedstoneUpdate((BlockPos)pos.leftNonnull()));
            }
            if (VoltmeterItem.lastRedstoneUpdate.isSignalSource() && matches) {
                text.addAll(Arrays.asList(I18n.m_118938_((String)"desc.immersiveengineering.info.redstoneLevel", (Object[])new Object[]{"<br>" + VoltmeterItem.lastRedstoneUpdate.rsLevel()}).split("<br>")));
            }
        }
        int col = 0xFFFFFF;
        int i = 0;
        RenderSystem.m_69478_();
        for (String s : text) {
            if (s == null) continue;
            s = s.trim();
            int w = ClientUtils.font().m_92895_(s);
            Font font = ClientUtils.font();
            float f = scaledWidth / 2.0f - (float)w / 2.0f;
            float f2 = scaledHeight / 2.0f + 4.0f;
            int n = i++;
            Objects.requireNonNull(ClientUtils.font());
            font.m_92811_(s, f, f2 + (float)(n * (9 + 2)), col, false, transform.m_85850_().m_85861_(), buffer, false, 0, 0xF000F0);
        }
        RenderSystem.m_69461_();
    }
}

